/* plot-cdf.c - plot cumulative distribution functions
 *
 * Copyright (C) 2006  Jochen Voss, Andreas Voss.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#ifndef _WIN32
#include <unistd.h>
#endif
#include <time.h>

#include "fast-dm.h"

#define  N  500

int
main (int argc, char **argv)
{
	struct F_calculator *fc;
	double  para[p_count], z, precision;
	double  dt = 5.0/N;
	double  F[2*N+1];
	clock_t	 start, stop;
	int  optc, i;

	para[p_a] = 1.0;
	z = 0.5;
	para[p_v] = 0.0;
	para[p_t0] = 0.3;
	para[p_sz] = 0.0;
	para[p_sv] = 0.0;
	para[p_st0] = 0.0;
	precision = 3;
#ifndef _WIN32
	while ((optc = getopt (argc, argv, "a:z:v:t:Z:V:T:p:")) != -1) {
		switch (optc) {
		case 'a':
			para[p_a] = atof (optarg);
			break;
		case 'z':
			z = atof (optarg);
			break;
		case 'v':
			para[p_v] = atof (optarg);
			break;
		case 't':
			para[p_t0] = atof (optarg);
			break;
		case 'Z':
			para[p_sz] = atof (optarg);
			break;
		case 'V':
			para[p_sv] = atof (optarg);
			break;
		case 'T':
			para[p_st0] = atof (optarg);
			break;
		case 'p':
			precision = atof(optarg);
			break;
		}
	}
#endif
	fprintf (stderr, "a = %g\n", para[p_a]);
	fprintf (stderr, "z = %g\n", z);
	fprintf (stderr, "v = %g\n", para[p_v]);
	fprintf (stderr, "t0 = %g\n", para[p_t0]);
	fprintf (stderr, "sz = %g\n", para[p_sz]);
	fprintf (stderr, "sv = %g\n", para[p_sv]);
	fprintf (stderr, "st0 = %g\n", para[p_st0]);
	fprintf (stderr, "precision = %g\n", precision);

	set_precision (precision);

	start = clock ();
	fc = F_new (para);
	F_start (fc, b_upper);
	for (i=0; i<=N; ++i) {
		F[N+i] = F_get_val (fc, i*dt, z);
	}
	F_start (fc, b_lower);
	for (i=1; i<=N; ++i) {
		F[N-i] = F_get_val (fc, i*dt, z);
	}
	F_delete (fc);
	stop = clock ();

	fprintf (stderr, "time = %.2f\n",
		 (double)(stop - start) / CLOCKS_PER_SEC);

	for (i=0; i<=2*N; ++i) {
		printf ("%f %.20f\n", (i-N)*dt, F[i]);
	}

	return  0;
}

/*
 * Local Variables:
 * c-file-style: "linux"
 * End:
 */
