/* erf.c - Gaussian error function
 *
 * by Thomas Meyer <tpmeyer@foxriver.com>, 2002
 *
 * A portable implementation of the Gaussian error function erf(),
 * using the Chebyshev algorithm.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: erf.c,v 1.3 2002/03/21 18:55:54 gtw Exp $
 */
 
#include <math.h>

double
erf (double x)
{
	double t, z, retval;
    
	z = fabs( x );
	t = 1.0 / ( 1.0 + 0.5 * z );
	retval = t * exp( -z * z - 1.26551223 + t *
			  ( 1.00002368 + t *
			    ( 0.37409196 + t *
			      ( 0.09678418 + t *
				( -0.18628806 + t *
				  ( 0.27886807 + t *
				    ( -1.13520398 + t *
				      ( 1.48851587 + t *
					( -0.82215223 + t *
					  0.1708727 ) ) ) ) ) ) ) ) );
	if( x < 0.0 )
		return retval - 1.0;
    
	return 1.0 - retval;
}

/*
 * Local Variables:
 * c-file-style: "linux"
 * End:
 */
